
static CTextEditLine *pClipboard;

void TextEdit_Clipboard_Init(void)
{
  pClipboard=NULL;
}

void TextEdit_Clipboard_Free(void)
{
  if(pClipboard!=NULL){
    while(pClipboard->pNext!=NULL){
      delete pClipboard->pNext;
    }
    delete pClipboard; pClipboard=NULL;
  }
}

static u32 SelectVSyncCount;

void TextEdit_SelectStart(void)
{
  _consolePrintf("Select start.\n");
  SelectTopPos=CursorPos;
  SelectVSyncCount=0;
}

void TextEdit_SelectVSyncUpdate(void)
{
  SelectVSyncCount++;
}

bool TextEdit_SelectCancel(void)
{
  if(SelectTopPos==(u32)-1) return(false);
  
  _consolePrintf("Select cancel.\n");
  SelectTopPos=(u32)-1;
  
  return(true);
}

static void TextEdit_SelectEnd_ins_Paste(u32 SelTopPos,u32 SelEndPos)
{
  _consolePrintf("Select paste.\n");
  
  if(SelectVSyncCount<=4){
    _consolePrintf("Very short pressing. canceled.\n");
    return;
  }
  
  if(pClipboard==NULL){
    SysMsg_Set("Clipboard is empty.");
    PlaySE_Long();
    return;
  }
  
  CTextEditLine *pCurLine=pClipboard;
  
  while(1){
    u32 strlen=pCurLine->GetLength();
    UnicodeChar *pstr=(UnicodeChar*)safemalloc(&MM_Temp,(strlen+1)*sizeof(UnicodeChar));
    Unicode_Copy(pstr,pCurLine->GetPlaneStringBuffer());
    pstr[strlen-1]=0; // delete return code.
    TextEdit_Add(pstr);
    if(pstr!=NULL){
      safefree(&MM_Temp,pstr); pstr=NULL;
    }
    pCurLine=pCurLine->pNext;
    if(pCurLine==NULL) break;
    TextEdit_AddEnter();
  }
  
  SysMsg_Set("Clipboard pasted.");
  PlaySE_Long();
}

void TextEdit_SelectEnd(void)
{
  if(SelectTopPos==(u32)-1) return;
  
  _consolePrintf("Select end. (%d,%d)\n",SelectTopPos,CursorPos);
  
  TextEdit_ClearAllLineState();
  
  u32 SelTopPos=SelectTopPos;
  u32 SelEndPos=CursorPos;
  SelectTopPos=(u32)-1;
  
  if(SelEndPos<SelTopPos){
    u32 tmp=SelEndPos;
    SelEndPos=SelTopPos;
    SelTopPos=tmp;
  }
  
  u32 SelLen=SelEndPos-SelTopPos;
  
  if(SelLen==0){
    TextEdit_SelectEnd_ins_Paste(SelTopPos,SelEndPos);
    return;
  }
  
  TextEdit_Clipboard_Free();
  
  pClipboard=new CTextEditLine();
  
  CTextEditLine *pCurLine=pTextEdit->pTopLine;
  
  while(1){
    const u32 curstrlen=pCurLine->GetLength();
    if(SelTopPos<curstrlen) break;
    SelTopPos-=curstrlen;
    SelEndPos-=curstrlen;
    pCurLine=pCurLine->pNext;
    if(pCurLine==NULL){
      _consolePrintf("SeekFrom overflow?\n");
      return;
    }
  }
  
  CTextEditLine *pDstLine=pClipboard;
  
  while(SelEndPos!=0){
    u32 strlen=pCurLine->GetLength();
    UnicodeChar *pstr=(UnicodeChar*)safemalloc(&MM_Temp,(strlen+1)*sizeof(UnicodeChar));
    Unicode_Copy(pstr,pCurLine->GetPlaneStringBuffer());
    pstr[strlen-1]=0; // delete return code.
    _consolePrintf("Process %d,%d,%d.\n",SelTopPos,SelEndPos,strlen);
    if(SelEndPos<strlen){
      pstr[SelEndPos]=0;
      pDstLine->AddStr((u32)-1,&pstr[SelTopPos]);
      if(pstr!=NULL){
        safefree(&MM_Temp,pstr); pstr=NULL;
      }
      break;
    }
    pDstLine->AddStr((u32)-1,&pstr[SelTopPos]);
    SelTopPos=0;
    SelEndPos-=strlen;
    if(pstr!=NULL){
      safefree(&MM_Temp,pstr); pstr=NULL;
    }
    pDstLine->AddNewLine();
    pDstLine=pDstLine->pNext;
    pCurLine=pCurLine->pNext;
    if(pCurLine==NULL) break;
  }
  
  SysMsg_Set("Selected text copy to clipboard.");
  PlaySE_Short();
}

